/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.list;

import com.google.common.annotations.VisibleForTesting;
import cz.insophy.inplan.util.list.SkipList;
import cz.insophy.inplan.util.list.SortedList;
import cz.insophy.inplan.util.list.TreeList;
import java.util.Comparator;

public class SortedLists {
    private static final Factory FACTORY = new SkipListFactory();

    public static <T> SortedList<T> create(Comparator<T> comparator) {
        return FACTORY.create(comparator);
    }

    public static <T> TreeList<T> newTreeList(Comparator<T> comparator) {
        return TreeList.create(comparator);
    }

    public static <T> SkipList<T> newSkipList(Comparator<T> comparator) {
        return SkipList.create(comparator);
    }

    @VisibleForTesting
    static interface Factory {
        public <T> SortedList<T> create(Comparator<T> var1);
    }

    @VisibleForTesting
    static class SkipListFactory
    implements Factory {
        SkipListFactory() {
        }

        @Override
        public <T> SortedList<T> create(Comparator<T> comparator) {
            return SkipList.create(comparator);
        }
    }

    @VisibleForTesting
    static class TreeListFactory
    implements Factory {
        TreeListFactory() {
        }

        @Override
        public <T> SortedList<T> create(Comparator<T> comparator) {
            return TreeList.create(comparator);
        }
    }
}

